package gov.va.med.mhv.admin.util;

import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;

import gov.va.med.mhv.common.data.model.FacilityInfo;

public abstract class AbstractLoginInfo implements Serializable {

	private static final long serialVersionUID = 1L;

	public static final String SEPARATOR = "^";

	private String userId = null;
	private String firstName = null;
	private String lastName = null;
	private String middleName = null;
	private String timestamp = String.valueOf(System.currentTimeMillis());
	private Set<String> facilityValues = new TreeSet<String>();
	private String checksum = null;
	private String source = null;
	private String requestUrl = null;
	private String authenticationURL = null;
	private String authenticationKey = null;

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getTimestamp() {
		return timestamp;
	}

	public Set<String> getFacilityValues() {
		return facilityValues;
	}

	public void addFacilityValue(FacilityInfo facilityInfo) {
		if (facilityInfo != null) {
			this.facilityValues.add(facilityInfo.getStationNumber() + SEPARATOR + facilityInfo.getName());
		}
	}

	public String getChecksum() {
		return checksum;
	}

	public void setChecksum(String checksum) {
		this.checksum = checksum;
	}

	public String getRequestUrl() {
		return requestUrl;
	}

	public void setRequestUrl(String requestUrl) {
		this.requestUrl = requestUrl;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public String getAuthenticationURL() {
		return authenticationURL;
	}

	public void setAuthenticationURL(String authenticationURL) {
		this.authenticationURL = authenticationURL;
	}

	public String getAuthenticationKey() {
		return authenticationKey;
	}

	public void setAuthenticationKey(String authenticationKey) {
		this.authenticationKey = authenticationKey;
	}

}
